﻿using Microsoft.Web.Http;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.Http.Description;
using System.Web.OData;
using System.Web.OData.Routing;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class ProviderNetworksController : ODataController
    {
        [ODataRoute("ProviderNetworks({key})")]
        public async Task<HttpResponseMessage> Get(int key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //look up the network id in model. 
                var network = NetworkIds.GetNetwork(key);
                //Retrieve the Provider Network
                var ppmsProviderNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.Id == network.Id);
                if (ppmsProviderNetwork != null)
                {
                    var ppmsProviderNetworkList = new List<ppms_vaprovidernetwork> { ppmsProviderNetwork };
                    var providerNetwork = await ProviderNetworkMap.MapProviderNetworks(ppmsProviderNetworkList, queryType, context);
                    return Request.CreateResponse(providerNetwork);
                }
            }
            var message = string.Format("No VA Provider Network found for given Network Id");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }
   
        [ODataRoute("ProviderNetworks({key})/VaProviderRelationships")]
        public async Task<HttpResponseMessage> GetProviderNetworkVaProviderRelationships([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //look up the network id in model. 
                var network = NetworkIds.GetNetwork(key);
                //Retrieve the Provider Network
                var ppmsProviderNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.Id == network.Id);
                if (ppmsProviderNetwork != null)
                {
                    var ppmsVaProviderRelationships = context.ppms_vaproviderrelationshipSet.Where(i => i.ppms_ProviderNetwork.Id == ppmsProviderNetwork.Id);
                    var ppmsVaProviderRelationshipsList = ppmsVaProviderRelationships.ToList();
                    if (ppmsVaProviderRelationshipsList.Any())
                    {
                        //Map Va Provider Relationships
                        var vaProviderRelationships = await VaProviderRelationshipMap.MapVaProviderRelationships(ppmsVaProviderRelationshipsList, "None", context);
                        return Request.CreateResponse(vaProviderRelationships);
                    }
                }
            }
            var message = string.Format("No Va Provider Relationships found for given Network");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderNetworks")]
        public async Task<HttpResponseMessage> Get()
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Networks 
                var ppmsProviderNetworks = context.ppms_vaprovidernetworkSet
                    .Where(i => i.ppms_name != null).Take(50);
                var ppmsProviderNetworksList = ppmsProviderNetworks.ToList();
                if (ppmsProviderNetworksList.Any())
                {
                    var providerNetworks = await ProviderNetworkMap.MapProviderNetworks(ppmsProviderNetworksList, queryType, context);
                    return Request.CreateResponse(providerNetworks);
                }
            }
            var message = string.Format("Provider Networks Not Found");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

      
        
    }
}